#!/bin/sh
# Update.sh version 1.00b
#
# Enigma 2 zap command
#
wget -q -O - http://127.0.0.1/web/zap?sRef=1:0:19:5225:C99:3:EB0000:0:0:0: NPO
#http://192.168.1.21/web/subservices  om de service id op te vragen
# Where to get the global update from
CLIENT=`hostname`
WWWDIR="http://www.holland-festival.nl/client/$CLIENT/user.tar.gz"
VERSION="http://www.holland-festival.nl/client/$CLIENT/clversion"

# Location of files.
GREP="/bin/grep"
CUT="/usr/bin/cut"
WGET="/usr/bin/wget"
CP="/bin/cp"
RM="/bin/rm"
ECHO="/bin/echo"
MKDIR="/bin/mkdir"
CAT="/bin/cat"
TAR="/bin/tar"
SH="/bin/sh"

#
# You not need to change from here
#
/var/tuxbox/channel.sh
sleep 5
#Verify files needed
if [ ! -x $GREP ] ; then
$ECHO "grep not installed"
exit
fi

if [ ! -x $CUT ] ; then
$ECHO "cut not installed"
exit
fi

# Check if update folder is there else create it
if [ ! -d /tmp/update ] ; then
$MKDIR /tmp/update
fi
$RM -f /tmp/update/*

# Get the version page for user update
$WGET -q -O /tmp/update/user_version "$VERSION"

# Get current version
VERSION_CURRENT=`cat /tmp/update/user_version`

if [ -z "$VERSION_CURRENT" ] ; then
$ECHO "can't get user current version"
exit
fi

# Get version installed
VERSION_USED=`cat /var/keys/clversion`
$ECHO "Current : $VERSION_CURRENT"
$ECHO "Used : $VERSION_USED"

if [ -z "$VERSION_USED" ] ; then
$ECHO "user update not installed"
exit
fi



if [ "$VERSION_USED" -ge "$VERSION_CURRENT" ] ; then
$ECHO "Is up to date"
exit
fi
$ECHO "need to update"

# Get the global update file
$WGET -q -O /tmp/update/user_update.tgz $WWWDIR

# Check if download was succesfull
if [ $? -eq 0 ]; then
        # Extract the user update
        cd /
        $TAR zxvf /tmp/update/user_update.tgz
        # Check if extract was successfull
                if [ ! $? -eq 0 ]; then
                $ECHO "ERROR extracting"
                exit
                fi
else
        $ECHO user update download failed
        exit
fi

#Verify if we need to run the update script
if [ ! -f /tmp/update/update.sh ] ; then
        $ECHO "No need to run update script"
else
        $SH /tmp/update/update.sh
        # Check if update was succesfull then update version
        if [ $? -eq 0 ]; then
        echo Update script run succesfull
        else
        echo Update script reported an error
        exit
        fi
fi

# It looks like all went well, so let's update the version
echo $VERSION_CURRENT > /var/keys/clversion
# Clean up the shit we made
$RM -rf /tmp/update











